package ags.game;

import java.util.ArrayList;
import java.util.List;
/*
 * Game.java
 *
 * Created on May 17, 2006, 7:07 PM
 *
 * Bean representing information about a game
 * @author blurry
 */
/**
 * Java bean representative of a game
 */
public class Game {
    /**
     * Display-friendly name of game
     */
    private String name;
    /**
     * game file name
     */
    private String file;
    /**
     * hex type, as per Ciderpress
     */
    private int type;
    /**
     * Starting address
     */
    private int start;
    /*
     * Is this a subroutine?  (if so, should execute it so it can return back to main loader when finished)
     */
    private boolean subroutine;
    /*
     * Is this an executable?  (if not, it should probably be loaded)
     */
    private boolean executable;
    private int offset;
    private int length;
    private List<Game> parts;
    /** Creates a new instance of Game */
    public Game() {
        parts = new ArrayList<Game>();
    }

    /**
     * Getter for name property
     * @return name property
     */
    public String getName() {
        return name;
    }

    /**
     * Setter for name property
     * @param name name property
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for file path property
     * @return file path property
     */
    public String getFile() {
        return file;
    }

    /**
     * Setter for file path property
     * @param file file path property
     */
    public void setFile(String file) {
        this.file = file;
    }

    /**
     * Getter for file type property
     * @return file type property
     */
    public int getType() {
        return type;
    }

    /**
     * Setter for file type property
     * @param type file type property
     */
    public void setType(int type) {
        this.type = type;
    }

    /**
     * Getter for start address property
     * @return start address property
     */
    public int getStart() {
        return start;
    }

    /**
     * Setter for start address property
     * @param start start address property
     */
    public void setStart(int start) {
        this.start = start;
    }

    public void setExecutable(boolean exec) {
        this.executable = exec;
    }
    
    public boolean isExecutable() {
        return this.executable;
    }
    public List<Game> getParts() {
        return parts;
    }

    public int getOffset() {
        return offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLength() {
        return length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean isSubroutine() {
        return subroutine;
    }

    public void setSubroutine(boolean subroutine) {
        this.subroutine = subroutine;
    }
}